Option Explicit
Const scriptName = "Move Set To Front"
Const scriptVer = "1.0.0"

' 1.0.0 - MJM - Initial Release


' Script constants, questions, and error messages.
Const warnQuitCreator = "Make sure Creator is closed before using this script."
Const qWhichSize = "Which size should be first in the list of sizes?"
Const errNotThereP = """"
Const errNotThereS = """ was not found in the list of size sets."

Const kDefaultPaperSize = "US Paper"

Dim WSHShell
Dim regRoot, regValue, regDataType
Dim response, continueOn
Dim counter, tempName
Dim errNum

Set WSHShell = WScript.CreateObject("WScript.Shell")

regRoot = "HKCU\Software\MultiAd\MultiAd Creator\PageSetNameList\"
regDataType = "REG_SZ"

response = MsgBox(warnQuitCreator, vbOkcancel, scriptName)
continueOn = (response = vbOK)

If continueOn Then
  ' Get space
  Dim defaultAnswer
  defaultAnswer = kDefaultPaperSize
  
  Dim loopDone
  loopDone = False
  Do
    response = InputBox(qWhichSize, scriptName, defaultAnswer)
    loopDone = (response = "")

    If loopDone Then
      continueOn = False
    Elseif IsNumeric(response) Then
      loopDone = True
      continueOn = (response <> "0")
    Else
      counter = 0
      Do While (Not loopDone) And (counter >= 0)
        Err.Clear
        On Error Resume Next
        tempName = WSHShell.RegRead(regRoot & counter)
        If Err.Number = 0 Then
          If tempName = response Then
            loopDone = True 
            response = CStr(counter)
            continueOn = (response <> "0")
          Else
            counter = counter + 1
          End If
        Else 
          Call MsgBox(errNotThereP & response & errNotThereS, vbOkonly, scriptname) 
	    defaultAnswer = response
	    counter = -1
	    Exit Do
	  End If
        On Error Goto 0 
      Loop
    End If
  Loop Until loopDone
End If

If continueOn Then
  tempName = WSHShell.RegRead(regRoot & "0")
  Call WSHShell.RegWrite(regRoot & "0", WSHShell.RegRead(regRoot & response), "REG_SZ")
  Call WSHShell.RegWrite(regRoot & response, tempName, "REG_SZ")
End If